<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\AdminController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\WOSController;
use App\Http\Controllers\ScopusController;
use App\Http\Controllers\ProiecteController;
use App\Http\Controllers\BreveteController;
use App\Http\Controllers\MarciController;
use App\Http\Controllers\ServiciiController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\StatisticaController;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('primapagina');
});

// Route::get('/dashboard', function () {
//     return view('admin.index');
// })->middleware(['auth', 'verified'])->name('dashboard');

// Route::middleware('auth')->group(function () {
//     Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
//     Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
//     Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
// });


Route::controller(AdminController::class)->group(function () {
    Route::get('/admin/logout', 'destroy')->name('admin.logout');
});

Route::middleware(['auth', 'verified'])->group(function () {
    Route::controller(DashboardController::class)->group(function () {
        Route::get('dashboard', 'Index')->name('dashboard');
    });
    Route::controller(WOSController::class)->group(function () {
        Route::get('wos/index', 'Index')->name('wos.index');
        Route::get('/wos', 'IndexWosUser')->name('page.wosUser');
        Route::get('/wosuserview/{id}/{nrcrt}', 'WosUserDetails')->name('WosUserDetails');
    });
    Route::controller(ScopusController::class)->group(function () {
        Route::get('scopus/index', 'Index')->name('scopus.index');
        Route::get('/scopus', 'IndexScopusUser')->name('page.scopusUser');
        Route::get('/scopususerview/{id}/{nrcrt}', 'ScopusUserDetails')->name('ScopusUserDetails');
    });
    Route::controller(ProiecteController::class)->group(function () {
        Route::get('proiecte/index', 'Index')->name('proiecte.index');
        Route::get('/proiecte', 'IndexProiecteUser')->name('page.proiecteUser');
        Route::get('/proiecteuserview/{id}/{nrcrt}', 'ProiecteUserDetails')->name('ProiecteUserDetails');
    });
    Route::controller(BreveteController::class)->group(function () {
        Route::get('brevete/index', 'Index')->name('brevete.index');
        Route::get('/brevete', 'IndexBreveteUser')->name('page.breveteUser');
        Route::get('/breveteuserview/{id}/{nrcrt}', 'BreveteUserDetails')->name('BreveteUserDetails');
    });
    Route::controller(MarciController::class)->group(function () {
        Route::get('marci/index', 'Index')->name('marci.index');
        Route::get('marci/index/page', 'IndexMarciUser')->name('page.marciUser');
        Route::get('/marciuserview/{id}/{nrcrt}', 'MarciUserDetails')->name('MarciUserDetails');
    });
    Route::controller(ServiciiController::class)->group(function () {
        Route::get('servicii/index', 'Index')->name('servicii.index');
        Route::get('servicii/index/page', 'IndexServiciiUser')->name('page.serviciiUser');
        Route::get('/serviciiuserview/{id}', 'ServiciiUserDetails')->name('ServiciiUserDetails');
    });

    Route::middleware(['is_admin'])->group(function () {
        Route::controller(WOSController::class)->group(function () {
            Route::get('wos/create', 'Create')->name('wos.create');
            Route::post('wos/store', 'Store')->name('wos.store');
            Route::get('wos/edit/{id}', 'Edit')->name('wos.edit');
            Route::post('wos/update/{id}', 'Update')->name('wos.update');
            Route::get('wos/delete/{id}', 'Delete')->name('wos.delete');
            Route::post('wos/addcomment/{id}', 'AddComment')->name('wos.addcomment');
        });

        Route::controller(ScopusController::class)->group(function () {
            Route::get('scopus/create', 'Create')->name('scopus.create');
            Route::post('scopus/store', 'Store')->name('scopus.store');
            Route::get('scopus/edit/{id}', 'Edit')->name('scopus.edit');
            Route::post('scopus/update/{id}', 'Update')->name('scopus.update');
            Route::get('scopus/delete/{id}', 'Delete')->name('scopus.delete');
            Route::post('scopus/addcomment/{id}', 'AddComment')->name('scopus.addcomment');
        });

        Route::controller(ProiecteController::class)->group(function () {
            Route::get('proiecte/create', 'Create')->name('proiecte.create');
            Route::post('proiecte.store', 'Store')->name('proiecte.store');
            Route::get('proiecte/edit/{id}', 'Edit')->name('proiecte.edit');
            Route::post('proiecte/update/{id}', 'Update')->name('proiecte.update');
            Route::get('proiecte/delete/{id}', 'Delete')->name('proiecte.delete');
        });

        Route::controller(BreveteController::class)->group(function () {
            Route::get('brevete/create', 'Create')->name('brevete.create');
            Route::post('brevete/store', 'Store')->name('brevete.store');
            Route::get('brevete/edit/{id}', 'Edit')->name('brevete.edit');
            Route::post('brevete/update/{id}', 'Update')->name('brevete.update');
            Route::get('brevete/delete/{id}', 'Delete')->name('brevete.delete');
        });

        Route::controller(MarciController::class)->group(function () {
            Route::get('marci/create', 'Create')->name('marci.create');
            Route::post('marci/store', 'Store')->name('marci.store');
            Route::get('marci/edit/{id}', 'Edit')->name('marci.edit');
            Route::post('marci/update/{id}', 'Update')->name('marci.update');
            Route::get('marci/delete/{id}', 'Delete')->name('marci.delete');
        });

        Route::controller(ServiciiController::class)->group(function () {
            Route::get('servicii/create', 'Create')->name('servicii.create');
            Route::post('servicii/store', 'Store')->name('servicii.store');
            Route::get('servicii/edit/{id}', 'Edit')->name('servicii.edit');
            Route::post('servicii/update/{id}', 'Update')->name('servicii.update');
            Route::get('servicii/delete/{id}', 'Delete')->name('servicii.delete');
        });

        Route::controller(UserController::class)->group(function () {
            Route::get('user/create', 'Create')->name('user.create');
            Route::post('user/store', 'Store')->name('user.store');
            Route::get('user/index', 'Index')->name('user.index');
            Route::get('user/edit/{id}', 'Edit')->name('user.edit');
            Route::post('user/update/{id}', 'Update')->name('user.update');
            Route::get('user/delete/{id}', 'Delete')->name('user.delete');
        });

        Route::controller(StatisticaController::class)->group(function() {
            Route::get('statistica', 'GenerareStatistica')->name('statistica');
            Route::get('chartWos', 'ChartWOS')->name('chartWos');
            Route::get('chartScopus', 'ChartScopus')->name('chartScopus');
            Route::get('chartProiecte', 'ChartProiecte')->name('chartProiecte');
            Route::get('chartBrevete', 'ChartBrevete')->name('chartBrevete');
            Route::get('chartMarci', 'ChartMarci')->name('chartMarci');
            Route::get('chartServicii', 'ChartServicii')->name('chartServicii');
            Route::get('chartGeneral', 'ChartGeneral')->name('chartGeneral');
        });

        Route::controller(DashboardController::class)->group(function () {
            Route::get('administrare', 'Admin')->name('administrare');
            Route::post('administrare/store', 'Store')->name('administrare.store');
        });


    });
});



require __DIR__ . '/auth.php';
