@extends('admin.admin_master')
@section('admin')
<!-- <link href="{{asset('backend/personale/popup.css')}}" rel="stylesheet" type="text/css" /> -->
<style>
    /* Styles for the modal */
    .modal {
      display: none;
      position: fixed;
      z-index: 1;
      left: 0;
      top: 0;
      width: 100%;
      height: 100%;
      overflow: auto;
      background-color: rgba(0, 0, 0, 0.5);
    }
   
    .modal-content {
      background-color: #fefefe;
      margin: 10% auto;
      padding: 20px;
      border: 1px solid #888;
      width: 80%;
      max-width: 600px;
      border-radius: 5px;
    }
   
    /* Styles for the link */
    .modal-link {
      text-decoration: underline;
      color: blue;
      cursor: pointer;
    }
  </style>
<div class="page-content">
    <div class="container-fluid">
    <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
        
                                        <h4 class="card-title">Lista WOS</h4>
        
                                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                            <thead>
                                            <tr>
                                                <th>Nr. Crt</th>
                                                <th>Titlu</th>
                                                <th>Autori</th>
                                                <th>Jurnal</th>
                                                <th>Anul publicarii</th>
                                                <th>Obs</th>
                                                @if(Auth()->user()->role)
                                                    <th>Actiuni</th>
                                                @endif
                                            </tr>
                                            </thead>
        
        
                                            <tbody>
                                                {{$numar}}
                                                    @php($i=1)
                                                    @foreach($woss as $wos)                                                    

                                                    <tr>
              
                                                            <td>{{$i++}}</td>
                                                            <td>  
                                                                <a class="modal-link" onclick="openModal({{$i}})">{{$wos->titlu}}</a>
                                                                        <div id="myModal{{$i}}" class="modal">
                                                                            <div class="modal-content">
                                                                                <h2>Comentarii pentru {{$wos->titlu}}</h2>
                                                                                <form method="POST" action="{{route('wos.addcomment', $wos->id)}}">@csrf
                                                                                    <textarea id="comment" style="width:550px;" name="comment" rows=5></textarea>
                                                                                    
                                                                                    <div style="color: red">
                                                                                        @error('comment')
                                                                                            {{ $message }}
                                                                                        @enderror 
                                                                                    </div>
                                                                                    <br>
                                                                                    <input type="submit" class="btn btn-success btn-rounded waves-effect waves-light" value="Salveaza">
                                                                                    <input type="button" onclick="closeModal({{$i}})" class="btn btn-success btn-rounded waves-effect waves-light" value="Inchide">
                                                                                </form>
                                                                            </div>
                                                                        </div>
                                                            </td>
                                                            <td>{{$wos->autori}}</td>
                                                            <td>{{$wos->jurnal}}</td>
                                                            <td>{{$wos->publicare}}</td>
                                                            <td>{{$wos->obs}}</td>
                                                            @if(Auth()->user()->role)
                                                                <td>
                                                                    <a href="{{route('wos.edit', $wos->id)}}" class="btn btn-success btn-rounded waves-effect waves-light">Modifica</a>
                                                                    <a href="{{route('wos.delete', $wos->id)}}" class="btn btn-danger btn-rounded waves-effect waves-light">Sterge</a>
                                                                </td>
                                                            @endif
                                                        </tr>

                                                    @endforeach

                                            </tbody>
                                        </table>
        
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
    </div>
</div>


@endsection
<script>
function openModal(i) {
    var modal = document.getElementById('myModal' + i);
    modal.style.display = 'block';
}
function closeModal(i) {
    var modal = document.getElementById('myModal' + i);
    modal.style.display = 'none';
}
</script>
