@extends('admin.admin_master')
@section('admin')

<div class="page-content">
    <div class="container-fluid">
    <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
        
                                        <h4 class="card-title">Lista utilizatori</h4>
        
                                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                            <thead>
                                            <tr>
                                                <th>Nr. Crt</th>
                                                <th>Nume</th>
                                                <th>Prenume</th>
                                                <th>Institutie</th>
                                                <th>Email</th>
                                                <th>Telefon</th>
                                                <th>Ocupatie</th>
                                                <th>Rol</th>
                                                <th>Actiuni</th>
                                            </tr>
                                            </thead>
        
        
                                            <tbody>
                                                    @php($i=1)
                                                    @foreach($users as $user)
                                                        <tr>
              
                                                            <td>{{$i++}}</td>
                                                            <td>{{$user->nume}}</td>
                                                            <td>{{$user->prenume}}</td>
                                                            <td>{{$user->institutie}}</td>
                                                            <td>{{$user->email}}</td>
                                                            <td>{{$user->ocupatie}}</td>
                                                            <td>
                                                                @if($user->role == 0) 
                                                                    Utilizator
                                                                
                                                                @else
                                                                    Administrator
                                                                @endif

                                                            </td>
                                                            <td>
                                                                <a href="{{route('user.edit', $user->id)}}" class="btn btn-success btn-rounded waves-effect waves-light">Modifica</a>
                                                                <a href="{{route('user.delete', $user->id)}}" class="btn btn-danger btn-rounded waves-effect waves-light">Sterge</a>
                                                            </td>
                                                        </tr>
                                                    @endforeach

                                            </tbody>
                                        </table>
        
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
    </div>
</div>


@endsection
