@extends('admin.admin_master')
@section('admin')

<div class="page-content">
    <div class="container-fluid">
    <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
        
                                        <h4 class="card-title">Lista proiecte de cercetare / consultanta</h4>

        
                                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                            <thead>
                                            <tr>
                                                <th>Nr. Crt</th>
                                                <th>Titlu</th>
                                                <th>Apel</th>
                                                <th>Finantare</th>
                                                <th>Cod</th>
                                                <th>Perioada</th>
                                                <th>Suma</th>
                                                <th>Director / Responsabil</th>
                                                @if(Auth()->user()->role)
                                                    <th>Actiuni</th>
                                                @endif
                                            </tr>
                                            </thead>
        
        
                                            <tbody>
                                                    @php($i=1)
                                                    @foreach($proiecte as $proiect)
                                                        <tr>
              
                                                            <td>{{$i++}}</td>
                                                            <td>{{$proiect->titlu}}</td>
                                                            <td>{{$proiect->apel}}</td>
                                                            <td>{{$proiect->finantare}}</td>
                                                            <td>{{$proiect->cod}}</td>
                                                            <td>{{$proiect->perioada}}</td>
                                                            <td>{{$proiect->suma}}</td>
                                                            <td>{{$proiect->responsabil}}</td>
                                                            @if(Auth()->user()->role)
                                                                <td>
                                                                    <a href="{{route('proiecte.edit', $proiect->id)}}" class="btn btn-success btn-rounded waves-effect waves-light">Modifica</a>
                                                                    <a href="{{route('proiecte.delete', $proiect->id)}}" class="btn btn-danger btn-rounded waves-effect waves-light">Sterge</a>
                                                                </td>
                                                            @endif
                                                        </tr>
                                                    @endforeach

                                            </tbody>
                                        </table>
        
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
    </div>
</div>


@endsection
