@extends('admin.admin_master')
@section('admin')

<div class="page-content">
    <div class="container-fluid">
        <h1 class="text-center">Brevete</h1>
        <div class="row mb-3 gap-3 gap-md-0">
            
            @foreach($datas as $key=>$data)
                <div class="col-md-3 p-0 mt-3">
                    <a href="{{ route('BreveteUserDetails', [$data->id, $key+1]) }}" class="card h-100 m-1">
                        <div class="card-body">
                            <!-- <h5>Brevet numarul {{$key+1}}</h5> -->
                            <div class=" flex-wrap mb-3">
                                <div class="d-flex flex-column">
                                    <h5>Titlu:  {{$data->titlu}}</h5>
                                </div>
                                <div class="d-flex flex-column">
                                    <h5>Anul publicării:</h5>
                                    <span class="h6">{{$data->an_emitere}}</span>
                                </div>
                            </div>
                            <div class="d-flex gap-3 flex-wrap">
                                <div class="d-flex flex-column">
                                    <h6>Cod cerere:</h6>
                                    <span class="h6">{{$data->cod_cerere}}</span>
                                </div>
                                <div class="d-flex flex-column">
                                    <h6>Cod brevet:</h6>
                                    <span class="h6">{{$data->cod_brevet}}</span>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach
           
        </div>

    </div>
</div>

<style>
    .card {
        transition: all .4s !important;
    }

    .card:hover {
        box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px !important;
    }
</style>

@endsection