@extends('admin.admin_master')
@section('admin')

<div class="page-content">
    <div class="container-fluid">
    <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
        
                                        <h4 class="card-title">Lista marci</h4>

        
                                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                            <thead>
                                            <tr>
                                                <th>Nr. Crt</th>
                                                <th>Titlu</th>
                                                <th>Categorie</th>
                                                <th>Autori</th>
                                                <th>Cod</th>
                                                <th>An emitere</th>
                                                @if(Auth()->user()->role)
                                                    <th>Actiuni</th>
                                                @endif
                                            </tr>
                                            </thead>
        
        
                                            <tbody>
                                                    @php($i=1)
                                                    @foreach($marci as $marca)
                                                        <tr>
              
                                                            <td>{{$i++}}</td>
                                                            <td>{{$marca->titlu}}</td>
                                                            <td>{{$marca->categorie}}</td>
                                                            <td>{{$marca->autori}}</td>
                                                            <td>{{$marca->cod}}</td>
                                                            <td>{{$marca->an_emitere}}</td>
                                                            @if(Auth()->user()->role)
                                                                <td>
                                                                    <a href="{{route('marci.edit', $marca->id)}}" class="btn btn-success btn-rounded waves-effect waves-light">Modifica</a>
                                                                    <a href="{{route('marci.delete', $marca->id)}}" class="btn btn-danger btn-rounded waves-effect waves-light">Sterge</a>
                                                                </td>
                                                            @endif
                                                        </tr>
                                                    @endforeach

                                            </tbody>
                                        </table>
        
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
    </div>
</div>


@endsection
