@extends('admin.admin_master')
@section('admin')

<div class="page-content">
    <div class="container-fluid">
    <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
        
                                        <h4 class="card-title">Lista brevete</h4>

        
                                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                            <thead>
                                            <tr>
                                                <th>Nr. Crt</th>
                                                <th>Titlu</th>
                                                <th>Autori</th>
                                                <th>Cod cerere</th>
                                                <th>Cod brevet</th>
                                                <th>Institutie emitenta</th>
                                                <th>An emitere</th>
                                                @if(Auth()->user()->role)
                                                    <th>Actiuni</th>
                                                @endif
                                            </tr>
                                            </thead>
        
        
                                            <tbody>
                                                    @php($i=1)
                                                    @foreach($brevete as $brevet)
                                                        <tr>
              
                                                            <td>{{$i++}}</td>
                                                            <td>{{$brevet->titlu}}</td>
                                                            <td>{{$brevet->autori}}</td>
                                                            <td>{{$brevet->cod_cerere}}</td>
                                                            <td>{{$brevet->cod_brevet}}</td>
                                                            <td>{{$brevet->emitent}}</td>
                                                            <td>{{$brevet->an_emitere}}</td>
                                                            @if(Auth()->user()->role)
                                                                <td>
                                                                    <a href="{{route('brevete.edit', $brevet->id)}}" class="btn btn-success btn-rounded waves-effect waves-light">Modifica</a>
                                                                    <a href="{{route('brevete.delete', $brevet->id)}}" class="btn btn-danger btn-rounded waves-effect waves-light">Sterge</a>
                                                                </td>
                                                            @endif
                                                        </tr>
                                                    @endforeach

                                            </tbody>
                                        </table>
        
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
    </div>
</div>


@endsection
