@extends('admin.admin_master')
@section('admin')

<div class="page-content">
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
        
                <h4 class="card-title">Situatie statistica</h4>
                                                
                                        <!-- Nav tabs -->
                                        <ul class="nav nav-pills nav-justified" role="tablist">
                                            <li class="nav-item waves-effect waves-light">
                                                <a class="nav-link active" data-bs-toggle="tab" href="#wos-1" role="tab">
                                                    <span class="d-block d-sm-none"><i class="fas fa-home"></i></span>
                                                    <span class="d-none d-sm-block">WOS</span> 
                                                </a>
                                            </li>
                                            <li class="nav-item waves-effect waves-light">
                                                <a class="nav-link" data-bs-toggle="tab" href="#scopus-1" role="tab">
                                                    <span class="d-block d-sm-none"><i class="far fa-user"></i></span>
                                                    <span class="d-none d-sm-block">Scopus</span> 
                                                </a>
                                            </li>
                                            <li class="nav-item waves-effect waves-light">
                                                <a class="nav-link" data-bs-toggle="tab" href="#proiecte-1" role="tab">
                                                    <span class="d-block d-sm-none"><i class="far fa-envelope"></i></span>
                                                    <span class="d-none d-sm-block">Proiecte de cercetare / consultanta</span>   
                                                </a>
                                            </li>
                                            <li class="nav-item waves-effect waves-light">
                                                <a class="nav-link" data-bs-toggle="tab" href="#brevete-1" role="tab">
                                                    <span class="d-block d-sm-none"><i class="fas fa-cog"></i></span>
                                                    <span class="d-none d-sm-block">Brevete</span>    
                                                </a>
                                            </li>                                            
                                            <li class="nav-item waves-effect waves-light">
                                                <a class="nav-link" data-bs-toggle="tab" href="#marci-1" role="tab">
                                                    <span class="d-block d-sm-none"><i class="fas fa-cog"></i></span>
                                                    <span class="d-none d-sm-block">Marci</span>    
                                                </a>
                                            </li>
                                            <li class="nav-item waves-effect waves-light">
                                                <a class="nav-link" data-bs-toggle="tab" href="#servicii-1" role="tab">
                                                    <span class="d-block d-sm-none"><i class="fas fa-cog"></i></span>
                                                    <span class="d-none d-sm-block">Servicii</span>    
                                                </a>
                                            </li>
                                            <li class="nav-item waves-effect waves-light">
                                                <a class="nav-link" data-bs-toggle="tab" href="#general-1" role="tab">
                                                    <span class="d-block d-sm-none"><i class="fas fa-cog"></i></span>
                                                    <span class="d-none d-sm-block">General</span>    
                                                </a>
                                            </li>
                                        </ul>
        
                                        <!-- Tab panes -->
                                        <div class="tab-content p-3 text-muted">
                                            <div class="tab-pane active" id="wos-1" role="tabpanel">
                                                <p class="mb-0">
                                                    <div style="display: flex; width: 35vw;">
                                                        <h5 class="me-5">Lista vizualizari wos</h5>  
                                                        <span><button class="btn btn-info ms-3" onclick="location.href='{{ route('chartWos') }}'">Grafic WOS</button></span>
                                                    </div>
                                                    <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Nr. Crt.</th>
                                                                        <th>Titlu</th>
                                                                        <th>Vizualizari</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    @if(count($woss)>0)
                                                                        @foreach($woss as $key=>$wos)
                                                                        <tr>
                                                                            <td class="align-middle" scope="row">{{$key+1}}</td>
                                                                            <td class="align-middle">{{$wos->titlu}}</td>
                                                                            <td class="align-middle">{{$wos->views}}</td>
                                                                        </tr>
                                                                        @endforeach
                                                                        @else
                                                                            <td>Nu exista elemente de afisat</td>
                                                                        @endif
                                                                </tbody>
                                                            </table>

                                                </p>
                                            </div>
                                            <div class="tab-pane" id="scopus-1" role="tabpanel">
                                                <p class="mb-0">
                                                    <div style="display: flex; width: 35vw;">
                                                        <h4 class="me-5">Lista vizualizari Scopus</h4>
                                                        <span>     <button class="btn btn-info ms-3" onclick="location.href='{{ route('chartScopus') }}'">Grafic Scopus</button></span>
                                                    </div>
                                                    <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                                        <thead>
                                                            <tr>
                                                                <th>Nr. Crt.</th>
                                                                <th>Titlu</th>
                                                                <th>Vizualizari</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @if(count($scopuss)>0)
                                                            @foreach($scopuss as $key=>$scopus)
                                                                <tr>
                                                                    <td class="align-middle" scope="row">{{$key+1}}</td>
                                                                    <td class="align-middle">{{$scopus->titlu}}</td>
                                                                    <td class="align-middle">{{$scopus->views}}</td>
                                                                </tr>
                                                                @endforeach
                                                                @else
                                                                <td>Nu exista elemente de afisat</td>
                                                                @endif
                                                        </tbody>
                                                    </table>
                                                </p>
                                            </div>
                                            <div class="tab-pane" id="proiecte-1" role="tabpanel">
                                                <p class="mb-0">
                                                    <div style="display: flex; width: 35vw;">
                                                        <h4 class="card-title">Lista vizualizari Proiecte de cercetare / consultanta</h4>
                                                        <span>     <button class="btn btn-info ms-3" onclick="location.href='{{ route('chartProiecte') }}'">Grafic Proiecte</button></span>
                                                    </div>
                                                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                                        <thead>
                                                            <tr>
                                                                <th>Nr. Crt.</th>
                                                                <th>Titlu</th>
                                                                <th>Vizualizari</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @if(count($proiecte)>0)
                                                            @foreach($proiecte as $key=>$proiect)
                                                                <tr>
                                                                    <td class="align-middle" scope="row">{{$key+1}}</td>
                                                                    <td class="align-middle">{{$proiect->titlu}}</td>
                                                                    <td class="align-middle">{{$proiect->views}}</td>
                                                                </tr>
                                                                @endforeach
                                                                @else
                                                                <td>Nu exista elemente de afisat</td>
                                                                @endif
                                                        </tbody>
                                                    </table>
                                                </p>
                                            </div>
                                            <div class="tab-pane" id="brevete-1" role="tabpanel">
                                                <p class="mb-0">
                                                <div style="display: flex; width: 35vw;">    
                                                    <h4 class="card-title">Lista vizualizari brevete</h4>
                                                    <span>     <button class="btn btn-info ms-3" onclick="location.href='{{ route('chartBrevete') }}'">Grafic Brevete</button></span>
                                                </div>
                                                    <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                                        <thead>
                                                            <tr>
                                                                <th>Nr. Crt.</th>
                                                                <th>Titlu</th>
                                                                <th>Vizualizari</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @if(count($brevete)>0)
                                                            @foreach($brevete as $key=>$brevet)
                                                                <tr>
                                                                    <td class="align-middle" scope="row">{{$key+1}}</td>
                                                                    <td class="align-middle">{{$brevet->titlu}}</td>
                                                                    <td class="align-middle">{{$brevet->views}}</td>
                                                                </tr>
                                                                @endforeach
                                                                @else
                                                                <td>Nu exista elemente de afisat</td>
                                                                @endif
                                                        </tbody>
                                                    </table>
                                                </p>
                                            </div>                                            
                                            <div class="tab-pane" id="marci-1" role="tabpanel">
                                                <p class="mb-0">
                                                <div style="display: flex; width: 35vw;">
                                                    <h4 class="card-title">Lista vizualizari marci</h4>
                                                    <span>     <button class="btn btn-info ms-3" onclick="location.href='{{ route('chartMarci') }}'">Grafic Marci</button></span>
                                                </div>
                                                    <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                                        <thead>
                                                            <tr>
                                                                <th>Nr. Crt.</th>
                                                                <th>Titlu</th>
                                                                <th>Vizualizari</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @if(count($marci)>0)
                                                            @foreach($marci as $key=>$marca)
                                                                <tr>
                                                                    <td class="align-middle" scope="row">{{$key+1}}</td>
                                                                    <td class="align-middle">{{$marca->titlu}}</td>
                                                                    <td class="align-middle">{{$marca->views}}</td>
                                                                </tr>
                                                                @endforeach
                                                                @else
                                                                <td>Nu exista elemente de afisat</td>
                                                                @endif
                                                        </tbody>
                                                    </table>
                                                </p>
                                            </div>
                                            <div class="tab-pane" id="servicii-1" role="tabpanel">
                                                <p class="mb-0">
                                                <div style="display: flex; width: 35vw;">
                                                    <h4 class="card-title">Lista vizualizari servicii</h4>
                                                    <span><button class="btn btn-info ms-3" onclick="location.href='{{ route('chartServicii') }}'">Grafic Servicii</button></span>
                                                </div>
                                                    <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                                        <thead>
                                                            <tr>
                                                                <th>Nr. Crt.</th>
                                                                <th>Titlu</th>
                                                                <th>Vizualizari</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @if(count($servicii)>0)
                                                            @foreach($servicii as $key=>$serviciu)
                                                                <tr>
                                                                    <td class="align-middle" scope="row">{{$key+1}}</td>
                                                                    <td class="align-middle">{{$serviciu->tip_serviciu}}</td>
                                                                    <td class="align-middle">{{$serviciu->views}}</td>
                                                                </tr>
                                                                @endforeach
                                                                @else
                                                                <td>Nu exista elemente de afisat</td>
                                                                @endif
                                                        </tbody>
                                                    </table>
                                                </p>
                                            </div>
                                            <div class="tab-pane" id="general-1" role="tabpanel">
                                                <p class="mb-0">
                                                <div style="display: flex; width: 35vw;">
                                                    <h4 class="card-title">Lista vizualizari pe categorii</h4>
                                                    <span><button class="btn btn-info ms-3" onclick="location.href='{{ route('chartGeneral') }}'">Grafic categorii</button></span>
                                                </div>
                                                    <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                                        <thead>
                                                            <tr>
                                                                <th>Nr. Crt.</th>
                                                                <th>Categorie</th>
                                                                <th>Vizualizari</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                                <tr>
                                                                    <td class="align-middle" scope="row">1</td>
                                                                    <td class="align-middle">Pagini wos</td>
                                                                    <td class="align-middle">{{$totalwos}}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td class="align-middle" scope="row">2</td>
                                                                    <td class="align-middle">Pagini Scopus</td>
                                                                    <td class="align-middle">{{$totalScopus}}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td class="align-middle" scope="row">3</td>
                                                                    <td class="align-middle">Pagini proiecte</td>
                                                                    <td class="align-middle">{{$totalProiecte}}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td class="align-middle" scope="row">4</td>
                                                                    <td class="align-middle">Pagini brevete</td>
                                                                    <td class="align-middle">{{$totalBrevete}}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td class="align-middle" scope="row">5</td>
                                                                    <td class="align-middle">Pagini marci</td>
                                                                    <td class="align-middle">{{$totalMarci}}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td class="align-middle" scope="row">6</td>
                                                                    <td class="align-middle">Pagini servicii</td>
                                                                    <td class="align-middle">{{$totalServicii}}</td>
                                                                </tr>
                                                        </tbody>
                                                    </table>
                                                </p>
                                            </div>
                                        </div>
        
                                    </div>
                                </div>
    </div>
</div>
@endsection