@extends('admin.admin_master')
@section('admin')

<div class="page-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-4">
                <div class="card card-body">

                    <div class="row mb-5">
                        <div class="col-md-6">
                            <h3 class="card-title">WOS</h3>
                            <p class="card-text">
                                @if($wos)
                                {{$wos->descriere}}
                                @endif</p>
                        </div>
                        <div class="col-md-6">
                            <div class="mt-4 mt-md-0">
                                <img class="rounded me-2" width="200" alt="200x200" @if($wos)
                                                                                    src="{{asset($wos->poza)}}"
                                                                                    @else src="poze/no_image.jpg"
                                                                                    @endif
                                                                                     data-holder-rendered="true">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <a href="{{route('wos.create')}}" class="btn btn-primary waves-effect waves-light col-md-4">Creaza</a>
                        <div class="col-md-4"></div>
                        <a href="{{route('wos.index')}}" class="btn btn-primary waves-effect waves-light col-md-4">Vizualizeaza</a>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card card-body">
                    <div class="row mb-5">
                        <div class="col-md-6">
                            <h3 class="card-title">Scopus</h3>
                            <p class="card-text">
                                @if($scopus)
                                    {{$scopus->descriere}}
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <div class="mt-4 mt-md-0">
                                <img class="rounded me-2" width="200" alt="200x200"@if($scopus)
                                                                                     src="{{asset($scopus->poza)}}"
                                                                                    @else src="poze/no_image.jpg"
                                                                                    @endif
                                                                                     data-holder-rendered="true">
                            </div>
                        </div>
                    </div>
                        <div class="row">
                            <a href="{{route('scopus.create')}}" class="btn btn-primary waves-effect waves-light col-md-4">Creaza</a>
                            <div class="col-md-4"></div>
                            <a href="{{route('scopus.index')}}" class="btn btn-primary waves-effect waves-light col-md-4">Vizualizeaza</a>
                        </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card card-body">
                    <div class="row mb-5">
                        <div class="col-md-6">
                            <h3 class="card-title">Proiecte de cercetare / consultanta</h3>
                            <p class="card-text">
                                @if($proiecte)
                                    {{$proiecte->descriere}}
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <div class="mt-4 mt-md-0">
                                <img class="rounded me-2" width="200" alt="200x200"@if($proiecte)
                                                                                     src="{{asset($proiecte->poza)}}"
                                                                                    @else src="poze/no_image.jpg"
                                                                                    @endif 
                                                                                     data-holder-rendered="true">
                            </div>
                        </div>
                    </div>
                        <div class="row">
                            <a href="{{route('proiecte.create')}}" class="btn btn-primary waves-effect waves-light col-md-4">Creaza</a>
                            <div class="col-md-4"></div>
                            <a href="{{route('proiecte.index')}}" class="btn btn-primary waves-effect waves-light col-md-4">Vizualizeaza</a>
                        </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="card card-body">

                    <div class="row mb-5">
                        <div class="col-md-6">
                            <h3 class="card-title">Brevete</h3>
                            <p class="card-text">
                                @if($brevete)
                                    {{$brevete->descriere}}
                                @endif
                                </p>
                        </div>
                        <div class="col-md-6">
                            <div class="mt-4 mt-md-0">
                                <img class="rounded me-2" width="200" alt="200x200" @if($brevete)
                                                                                        src="{{asset($brevete->poza)}}"
                                                                                    @else src="poze/no_image.jpg"
                                                                                    @endif 
                                                                                     data-holder-rendered="true">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <a href="{{route('brevete.create')}}" class="btn btn-primary waves-effect waves-light col-md-4">Creaza</a>
                        <div class="col-md-4"></div>
                        <a href="{{route('brevete.index')}}" class="btn btn-primary waves-effect waves-light col-md-4">Vizualizeaza</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card card-body">

                    <div class="row mb-5">
                        <div class="col-md-6">
                            <h3 class="card-title">Marci</h3>
                            <p class="card-text">
                                @if($marci)
                                    {{$marci->descriere}}
                                @endif
                                </p>
                        </div>
                        <div class="col-md-6">
                            <div class="mt-4 mt-md-0">
                                <img class="rounded me-2" width="200" alt="200x200" @if($marci)
                                                                                     src="{{asset($marci->poza)}}" 
                                                                                    @else src="poze/no_image.jpg"
                                                                                    @endif 
                                                                                     data-holder-rendered="true">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <a href="{{route('marci.create')}}" class="btn btn-primary waves-effect waves-light col-md-4">Creaza</a>
                        <div class="col-md-4"></div>
                        <a href="{{route('marci.index')}}" class="btn btn-primary waves-effect waves-light col-md-4">Vizualizeaza</a>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card card-body">

                    <div class="row mb-5">
                        <div class="col-md-6">
                            <h3 class="card-title">Servicii</h3>
                            <p class="card-text">
                                @if($servicii)
                                    {{$servicii->descriere}}
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <div class="mt-4 mt-md-0">
                                <img class="rounded me-2" width="200" alt="200x200" @if($servicii)
                                                                                         src="{{asset($servicii->poza)}}"
                                                                                    @else src="poze/no_image.jpg"
                                                                                    @endif 
                                                                                     data-holder-rendered="true">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <a href="{{route('marci.create')}}" class="btn btn-primary waves-effect waves-light col-md-4">Creaza</a>
                        <div class="col-md-4"></div>
                        <a href="{{route('marci.index')}}" class="btn btn-primary waves-effect waves-light col-md-4">Vizualizeaza</a>
                    </div>
                </div>
            </div>
        </div>    
    </div>
</div>

@endsection