<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\wos;

class WOSController extends Controller
{

    public function WosUserDetails($id, $nrcrt)
    {
        wos::find($id)->increment('views');
        $curent= $nrcrt;
        $wosPage = WOS::find($id);
        return view('page.wos.indexUserwos', compact('wosPage', 'curent'));
    }

    public function IndexWosUser()
    {
        $datas = wos::all();
        return view('page.wos.wos', compact('datas'));
    }


    public function Create()
    {
        return view('wos.create');
    }

    public function Index()
    {
        $numar = wos::get()->count();
        $woss = wos::all();
        return view('wos.index', compact(['woss', 'numar']));
    }

    public function Store(Request $request)
    {
        $request->validate([
            'titlu' => ['required', 'string', 'max:255'],
            'autori' => ['required', 'string', 'max:255'],
            'jurnal' => ['required', 'string', 'max:255'],
            'publicare' => ['required'],
        ], [
            'titlu.required' => 'Trebuie completat titlul',
            'autori.required' => 'Trebuie completat autorul',
            'jurnal.required' => 'Trebuie completat jurnalul',
            'publicare.email' => 'Trebuie completat anul publicarii',
        ]);

        $wos = wos::create([
            'titlu' => $request->titlu,
            'autori' => $request->autori,
            'jurnal' => $request->jurnal,
            'publicare' => $request->publicare,
            'obs' => $request->obs,
        ]);

        return redirect()->route('wos.index');
    }

    public function Edit($id)
    {
        $data = wos::find($id);
        return view('wos.edit', compact('data'));
    }

    public function Update(Request $request, $id)
    {

        $request->validate([
            'titlu' => ['required', 'string', 'max:255'],
            'autori' => ['required', 'string', 'max:255'],
            'jurnal' => ['required', 'string', 'max:255'],
            'publicare' => ['required'],
        ], [
            'titlu.required' => 'Trebuie completat titlul',
            'autori.required' => 'Trebuie completat autorul',
            'jurnal.required' => 'Trebuie completat jurnalul',
            'publicare.email' => 'Trebuie completat anul publicarii',
        ]);

        $wos = wos::find($id);
        $wos->titlu = $request->titlu;
        $wos->autori = $request->autori;
        $wos->jurnal = $request->jurnal;
        $wos->publicare = $request->publicare;
        $wos->obs = $request->obs;
        $wos->save();

        return redirect()->route('wos.index');
    }

    public function delete($id)
    {
        $wos = wos::find($id);
        $wos->delete();

        return redirect()->route('wos.index');
    }

    public function AddComment(Request $request, $id)
    {
        $request->validate([
            'comment' => ['required', 'string', 'max:500'],
        ], [
            'comment.max' => 'Sunt permise max 500 caractere'
        ]);
        // dd($request->comentariu);
        wos::where('id', $id)->update([
            'comment' => $request->comment
        ]);

        return redirect()->route('wos.index');
    }
}
