<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;

class UserController extends Controller
{
    public function Create(){
        return view('user.create');
    }

    public function Index(){
        $users = User::all();
        return view('user.index', compact('users'));
    }

    public function Store(Request $request){
        $request->validate([
            'nume' => ['required', 'string', 'max:255'],
            'prenume' => ['required', 'string', 'max:255'],
            'institutie' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:'.User::class],
            'telefon' => ['required', 'string', 'min:10', 'max:15'],
            'ocupatie' => ['required'],
            'role' => ['required'],
            'password' => ['required', Rules\Password::defaults()],
        ],[
            'nume.required'=>'Trebuie completat numele',
            'prenume.required'=>'Trebuie completat prenumele',
            'email.required'=>'Trebuie completata adresa de mail',
            'email.email'=>'Trebuie completata o adresa de mail valida',
            'email.unique'=>'Adresa de mail este deja inregistrata',
            'telefon.required'=>'Trebuie completat numarul de telefon',
            'telefon.min'=>'Numarul de telefon trebuie sa aiba minim 10 cifre',
            'ocupatie.required'=>'Trebuie sa alegeti o ocuptie',
            'role.required'=>'Trebuie sa alegeti un rol',
            'password.required'=>'Trebuie sa completati o parola',
        ]);

        $user = User::create([
            'nume' => $request->nume,
            'prenume' => $request->prenume,
            'institutie' => $request->institutie,
            'email' => $request->email,
            'telefon' => $request->telefon,
            'ocupatie' => $request->ocupatie,
            'role' => $request->role,
            'password' => Hash::make($request->password),
        ]);

        return redirect()->route('user.index');
    }

    public function Edit($id){
        $data = User::find($id);
        return view('user.edit', compact('data'));
    }

    public function Update(Request $request, $id){

        if(!$request->password){
            $data = User::find($id);
            $data->nume = $request->nume;
            $data->prenume = $request->prenume;
            $data->institutie = $request->institutie;
            $data->email = $request->email;
            $data->telefon = $request->telefon;
            $data->ocupatie = $request->ocupatie;
            $data->role = $request->role;
            $data->save();
        }else{
            $data = User::find($id);
            $data->nume = $request->nume;
            $data->prenume = $request->prenume;
            $data->institutie = $request->institutie;
            $data->email = $request->email;
            $data->telefon = $request->telefon;
            $data->ocupatie = $request->ocupatie;
            $data->role = $request->role;
            $data->password = Hash::make($request->password);
            $data->save();
        }
        return redirect()->route('user.index');
    }

    public function delete($id){
        $data = User::find($id);
        $data->delete();
        return redirect()->route('user.index');
    }


}
