<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Servicii;

class ServiciiController extends Controller
{

    public function ServiciiUserDetails($id)
    {
        Servicii::find($id)->increment('views');
        $serviciiPage = Servicii::find($id);
        return view('page.servicii.indexUserServicii', compact('serviciiPage'));
    }

    public function IndexServiciiUser()
    {
        $datas = Servicii::all();
        return view('page.servicii.servicii', compact('datas'));
    }

    public function Create()
    {
        return view('servicii.create');
    }

    public function Index()
    {
        $servicii = Servicii::all();
        return view('servicii.index', compact('servicii'));
    }

    public function Store(Request $request)
    {
        $request->validate([
            'tip_serviciu' => ['required', 'string', 'max:255'],
            'descriere' => 'required',
            'locatie' => ['required', 'string', 'max:255'],
        ], [
            'tip_serviciu.required' => "Trebuie completat campul tip serviciu",
            'descriere.required' => "Trebuie completat campul descriere",
            'locatie.required' => "Trebuie completat campul locatie",
        ]);

        $servicii = Servicii::create([
            'tip_serviciu' => $request->tip_serviciu,
            'descriere' => $request->descriere,
            'locatie' => $request->locatie,
        ]);

        return redirect()->route('servicii.index');
    }

    public function Edit($id)
    {
        $data = Servicii::find($id);
        return view('servicii.edit', compact('data'));
    }

    public function Update(Request $request, $id)
    {
        $request->validate([
            'tip_serviciu' => ['required', 'string', 'max:255'],
            'descriere' => 'required',
            'locatie' => ['required', 'string', 'max:255'],
        ], [
            'tip_serviciu.required' => "Trebuie completat campul tip serviciu",
            'descriere.required' => "Trebuie completat campul descriere",
            'locatie.required' => "Trebuie completat campul locatie",
        ]);

        $servicii = Servicii::find($id);
        $servicii->tip_serviciu = $request->tip_serviciu;
        $servicii->descriere = $request->descriere;
        $servicii->locatie = $request->locatie;
        $servicii->save();

        return redirect()->route('servicii.index');
    }

    public function delete($id)
    {
        $servicii = Servicii::find($id);
        $servicii->delete();

        return redirect()->route('servicii.index');
    }
}
