<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Scopus;

class ScopusController extends Controller
{
    public function ScopusUserDetails($id, $nrcrt)
    {
        Scopus::find($id)->increment('views');
        $scopusPage = Scopus::find($id);
        $curent = $nrcrt;
        return view('page.scopus.indexUserScopus', compact('scopusPage', 'curent'));
    }

    public function IndexScopusUser()
    {
        $datas = Scopus::all();
        return view('page.scopus.scopus', compact('datas'));
    }

    public function Create()
    {
        return view('scopus.create');
    }

    public function Index()
    {
        $scopuss = scopus::all();
        return view('scopus.index', compact('scopuss'));
    }

    public function Store(Request $request)
    {
        $request->validate([
            'titlu' => ['required', 'string', 'max:255'],
            'autori' => ['required', 'string', 'max:255'],
            'jurnal' => ['required', 'string', 'max:255'],
            'publicare' => ['required'],
        ], [
            'titlu.required' => 'Trebuie completat titlul',
            'autori.required' => 'Trebuie completat autorul',
            'jurnal.required' => 'Trebuie completat jurnalul',
            'publicare.email' => 'Trebuie completat anul publicarii',
        ]);

        $wos = scopus::create([
            'titlu' => $request->titlu,
            'autori' => $request->autori,
            'jurnal' => $request->jurnal,
            'publicare' => $request->publicare,
            'obs' => $request->obs,
        ]);

        return redirect()->route('scopus.index');
    }

    public function Edit($id)
    {
        $data = scopus::find($id);
        return view('scopus.edit', compact('data'));
    }

    public function Update(Request $request, $id)
    {

        $request->validate([
            'titlu' => ['required', 'string', 'max:255'],
            'autori' => ['required', 'string', 'max:255'],
            'jurnal' => ['required', 'string', 'max:255'],
            'publicare' => ['required'],
        ], [
            'titlu.required' => 'Trebuie completat titlul',
            'autori.required' => 'Trebuie completat autorul',
            'jurnal.required' => 'Trebuie completat jurnalul',
            'publicare.email' => 'Trebuie completat anul publicarii',
        ]);

        $scopus = scopus::find($id);
        $scopus->titlu = $request->titlu;
        $scopus->autori = $request->autori;
        $scopus->jurnal = $request->jurnal;
        $scopus->publicare = $request->publicare;
        $scopus->obs = $request->obs;
        $scopus->save();

        return redirect()->route('scopus.index');
    }

    public function delete($id)
    {
        $scopus = scopus::find($id);
        $scopus->delete();

        return redirect()->route('scopus.index');
    }

    public function AddComment(Request $request, $id)
    {
        $request->validate([
            'comment' => ['required', 'string', 'max:500'],
        ], [
            'comment.max' => 'Sunt permise max 500 caractere'
        ]);
        // dd($request->comentariu);
        scopus::where('id', $id)->update([
            'comment' => $request->comment
        ]);

        return redirect()->route('scopus.index');
    }
}
