<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Proiecte;

class ProiecteController extends Controller
{
    public function IndexProiecteUser(){
        $datas = Proiecte::all();
        return view('page.proiecte.indexUserProiecte', compact('datas'));
    }

    public function ProiecteUserDetails($id, $nrcrt){
        Proiecte::find($id)->increment('views');
        $curent = $nrcrt;
        $proiectePage = Proiecte::find($id);
        return view('page..proiecte.proiecte', compact('proiectePage', 'curent'));
    }

    public function Create(){
        return view('proiecte.create');
    }

    public function Index(){
        $proiecte = Proiecte::all();
        return view('proiecte.index', compact('proiecte'));
    }

    public function Store(Request $request){
            $request->validate([
                'titlu' => ['required', 'string', 'max:255'],
                'apel' => ['required', 'string', 'max:255'],
                'finantare' => ['required', 'string', 'max:255'],
                'cod' => ['required', 'string', 'max:255'],
                'perioada' => ['required', 'string', 'max:255'],
                'suma' => 'required',
                'responsabil' => ['required', 'string', 'max:255'],
            ],[
                'titlu.required'=>"Trebuie completat campul titlu",
                'apel.required'=>"Trebuie completat campul apel",
                'finantare.required'=>"Trebuie completat campul finantare",
                'cod.required'=>"Trebuie completat campul cod",
                'perioada.required'=>"Trebuie completat campul perioada",
                'suma.required'=>"Trebuie completat campul suma",
                'responsabil.required'=>"Trebuie completat campul responsabil",
            ]);
        $proiecte  = Proiecte::create([
            'titlu' =>$request->titlu,
            'apel' =>$request->apel,
            'finantare' =>$request->finantare,
            'cod' =>$request->cod,
            'perioada' =>$request->perioada,
            'suma' =>$request->suma,
            'responsabil' =>$request->responsabil,
        ]);

        return redirect()->route('proiecte.index');
    }

    public function Edit($id){
        $data = Proiecte::find($id);
        return view('proiecte.edit', compact('data'));
    }

    public function Update(Request $request, $id){
        $request->validate([
            'titlu' => ['required', 'string', 'max:255'],
            'apel' => ['required', 'string', 'max:255'],
            'finantare' => ['required', 'string', 'max:255'],
            'cod' => ['required', 'string', 'max:255'],
            'perioada' => ['required', 'string', 'max:255'],
            'suma' => 'required',
            'responsabil' => ['required', 'string', 'max:255'],
        ],[
            'titlu.required'=>"Trebuie completat campul titlu",
            'apel.required'=>"Trebuie completat campul apel",
            'finantare.required'=>"Trebuie completat campul finantare",
            'cod.required'=>"Trebuie completat campul cod",
            'perioada.required'=>"Trebuie completat campul perioada",
            'suma.required'=>"Trebuie completat campul suma",
            'responsabil.required'=>"Trebuie completat campul responsabil",
        ]);

        $proiecte = Proiecte::find($id);
        $proiecte->titlu = $request->titlu;
        $proiecte->apel = $request->apel;
        $proiecte->finantare = $request->finantare;
        $proiecte->cod = $request->cod;
        $proiecte->perioada = $request->perioada;
        $proiecte->suma = $request->suma;
        $proiecte->responsabil = $request->responsabil;
        $proiecte->save();

        return redirect()->route('proiecte.index');
    }

    public function delete($id){
        $proiect = Proiecte::find($id);
        $proiect->delete();

        return redirect()->route('proiecte.index');
    }

    
}
