<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Marci;

class MarciController extends Controller
{
    public function IndexMarciUser(){
        $datas = Marci::all();
        return view('page.marci.indexUserMarci', compact('datas'));
    }

    public function MarciUserDetails($id, $nrcrt)
    {
        Marci::find($id)->increment('views');
        $curent = $nrcrt;
        $marciPage = Marci::find($id);
        return view('page.marci.marci', compact('marciPage', 'curent'));
    }

    public function Create(){
        return view('marci.create');
    }

    public function Index(){
        $marci = Marci::all();
        return view('marci.index', compact('marci'));
    }

    public function Store(Request $request){
        $request->validate([
            'titlu' => ['required', 'string', 'max:255'],
            'categorie' => ['required', 'string', 'max:255'],
            'autori' => ['required', 'string', 'max:255'],
            'cod' => ['required', 'string', 'max:255'],
            'an_emitere' => 'required',
        ],[
            'titlu.required'=>"Trebuie completat campul titlu",
            'categorie.required'=>"Trebuie completat campul categorie",
            'autori.required'=>"Trebuie completat campul autori",
            'cod.required'=>"Trebuie completat campul cod",
            'an_emitere.required'=>"Trebuie completat campul an emitere",
        ]);
        $marci = Marci::create([
            'titlu' => $request->titlu,
            'categorie' => $request->categorie,
            'autori' => $request->autori,
            'cod' => $request->cod,
            'an_emitere' => $request->an_emitere,
        ]);

        return redirect()->route('marci.index');
    }

    public function Edit($id){
        $data = Marci::find($id);
        return view('marci.edit', compact('data'));
    }

    public function Update(Request $request, $id){
        $request->validate([
            'titlu' => ['required', 'string', 'max:255'],
            'categorie' => ['required', 'string', 'max:255'],
            'autori' => ['required', 'string', 'max:255'],
            'cod' => ['required', 'string', 'max:255'],
            'an_emitere' => 'required',
        ],[
            'titlu.required'=>"Trebuie completat campul titlu",
            'categorie.required'=>"Trebuie completat campul categorie",
            'autori.required'=>"Trebuie completat campul cod autori",
            'cod.required'=>"Trebuie completat campul cod brevet",
            'an_emitere.required'=>"Trebuie completat campul an emitere",
        ]);

        $marci = Marci::find($id);
        $marci->titlu = $request->titlu;
        $marci->categorie = $request->categorie;
        $marci->autori = $request->autori;
        $marci->cod = $request->cod;
        $marci->an_emitere = $request->an_emitere;
        $marci->save();

        return redirect()->route('marci.index');
    }

    public function delete($id){
        $marci = Marci::find($id);
        $marci->delete();

        return redirect()->route('marci.index'); 
    }
}
