<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Administrare;
use Image;

class DashboardController extends Controller
{
    public function Index(){

        $wos = null;
        $scopus = null;
        $proiecte = null;
        $brevete = null;
        $marci = null;
        $servicii = null;

        if(Auth()->user()->role){
            $wos = Administrare::where('element', "wos")->first();
            $scopus = Administrare::where('element', "scopus")->first();
            $proiecte = Administrare::where('element', "proiecte")->first();
            $brevete = Administrare::where('element', "brevete")->first();
            $marci = Administrare::where('element', "marci")->first();
            $servicii = Administrare::where('element', "servicii")->first();

            return view('admin.dashboard', compact('wos', 'scopus', 'proiecte', 'brevete', 'marci', 'servicii'));
        }

        return view('user.dashboard', compact('wos', 'scopus', 'proiecte', 'brevete', 'marci', 'servicii'));
    }

    public function Admin(){
        return view ('admin.general.admin');
    }

    public function Store(Request $request){
        $request->validate([
            'element' => ['required'],
            'descriere' => ['required'],
            'poza' => ['required'],
        ]);
        $verif = Administrare::where('element', $request->element)->first();
        if(!isset($verif)){

            $fisierepoze = $request->poza;
            $filename=hexdec(uniqid()).'.'.$fisierepoze->getClientOriginalExtension();
            Image::make($fisierepoze)->resize(800,600)->save('poze/'.$filename);
            $filenamewp = 'poze/' . $filename;
            // $fisierepoze->move('poze/', $filename);
            $data = new Administrare();
            $data->element = $request->element;
            $data->descriere = $request->descriere;
            $data->poza = $filenamewp;
            $data->save();
        }else{
            $fisierepoze = $request->poza;
            $filename=hexdec(uniqid()).'.'.$fisierepoze->getClientOriginalExtension();
            Image::make($fisierepoze)->resize(800,600)->save('poze/'.$filename);
            $filenamewp = 'poze/' . $filename;

            Administrare::where('element', $request->element)->update([
                'descriere' => $request->descriere,
                'poza' =>  $filenamewp,
                ]);
        }



        return redirect()->route('dashboard');
        }

}
