<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Brevete;

class BreveteController extends Controller
{
    public function BreveteUserDetails($id, $nrcrt)
    {
        Brevete::find($id)->increment('views');
        $brevetePage = Brevete::find($id);
        $curent = $nrcrt;
        return view('page.brevete.indexUserBrevete', compact('brevetePage', 'curent'));
    }

    public function IndexBreveteUser()
    {
        $datas = Brevete::all();
        return view('page.brevete.brevete', compact('datas'));
    }

    public function Create()
    {
        return view('brevete.create');
    }

    public function Index()
    {
        $brevete = Brevete::all();
        return view('brevete.index', compact('brevete'));
    }

    public function Store(Request $request)
    {

        $request->validate([
            'titlu' => ['required', 'string', 'max:255'],
            'autori' => ['required', 'string', 'max:255'],
            'cod_cerere' => ['required', 'string', 'max:255'],
            'cod_brevet' => ['required', 'string', 'max:255'],
            'emitent' => ['required', 'string', 'max:255'],
            'an_emitere' => 'required',
        ], [
            'titlu.required' => "Trebuie completat campul titlu",
            'autori.required' => "Trebuie completat campul autori",
            'cod_cerere.required' => "Trebuie completat campul cod cerere",
            'cod_brevet.required' => "Trebuie completat campul cod brevet",
            'emitent.required' => "Trebuie completat campul emitent",
            'an_emitere.required' => "Trebuie completat campul an emitere",
        ]);

        $brevete = Brevete::create([
            'titlu' => $request->titlu,
            'autori' => $request->autori,
            'cod_cerere' => $request->cod_cerere,
            'cod_brevet' => $request->cod_brevet,
            'emitent' => $request->emitent,
            'an_emitere' => $request->an_emitere,
        ]);

        return redirect()->route('brevete.index');
    }

    public function Edit($id)
    {
        $data = Brevete::find($id);
        return view('brevete.edit', compact('data'));
    }

    public function Update(Request $request, $id)
    {
        $request->validate([
            'titlu' => ['required', 'string', 'max:255'],
            'autori' => ['required', 'string', 'max:255'],
            'cod_cerere' => ['required', 'string', 'max:255'],
            'cod_brevet' => ['required', 'string', 'max:255'],
            'emitent' => ['required', 'string', 'max:255'],
            'an_emitere' => 'required',
        ], [
            'titlu.required' => "Trebuie completat campul titlu",
            'autori.required' => "Trebuie completat campul autori",
            'cod_cerere.required' => "Trebuie completat campul cod cerere",
            'cod_brevet.required' => "Trebuie completat campul cod brevet",
            'emitent.required' => "Trebuie completat campul emitent",
            'an_emitere.required' => "Trebuie completat campul an emitere",
        ]);

        $brevete = Brevete::find($id);
        $brevete->titlu = $request->titlu;
        $brevete->autori = $request->autori;
        $brevete->cod_cerere = $request->cod_cerere;
        $brevete->cod_brevet = $request->cod_brevet;
        $brevete->emitent = $request->emitent;
        $brevete->an_emitere = $request->an_emitere;
        $brevete->save();

        return redirect()->route('brevete.index');
    }

    public function Delete($id)
    {
        $brevete = Brevete::find($id);
        $brevete->delete();

        return redirect()->route('brevete.index');
    }
}
