<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\View\View;
use Illuminate\Support\Facades\Mail;
use App\Mail\NewAccountMail;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(): View
    {
        return view('auth.register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {
        //dd($request->captcha);
        $request->validate([
            'nume' => ['required', 'string', 'max:255'],
            'prenume' => ['required', 'string', 'max:255'],
            'institutie' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:'.User::class],
            'telefon' => ['required', 'string', 'min:10', 'max:15'],
            'ocupatie' => ['required'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
            'captcha' => ['required', 'captcha'],
        ],[
            'nume.required'=>'Trebuie completat numele',
            'prenume.required'=>'Trebuie completat prenumele',
            'email.required'=>'Trebuie completata adresa de mail',
            'email.email'=>'Trebuie completata o adresa de mail valida',
            'email.unique'=>'Adresa de mail este deja inregistrata',
            'telefon.required'=>'Trebuie completat numarul de telefon',
            'telefon.min'=>'Numarul de telefon trebuie sa aiba minim 10 cifre',
            'ocupatie.required'=>'Trebuie sa alegeti o ocuptie',
            'password.required'=>'Trebuie sa completati o parola',
            'password.confirmed'=>'Parolele nu sunt identince',
        ]);

        $user = User::create([
            'nume' => $request->nume,
            'prenume' => $request->prenume,
            'institutie' => $request->institutie,
            'email' => $request->email,
            'telefon' => $request->telefon,
            'ocupatie' => $request->ocupatie,
            'role' => 0,
            'password' => Hash::make($request->password),
        ]);

        event(new Registered($user));

        Auth::login($user);

        return redirect(RouteServiceProvider::HOME);
    }

    public function reloadCaptcha()
    {
        return response()->json(['captcha'=> captcha_img('math')]);
    }

}
